package h.com.serialapp.activity.fragment

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import h.com.serialapp.R
import h.com.serialapp.adapter.LogAdapter
import h.com.serialportapi.comn.CommPacket
import h.com.serialportapi.comn.SerialReadThread
import h.com.serialportapi.comn.message.IMessage
import h.com.serialportapi.comn.message.LogManager
import kotlinx.android.synthetic.main.view_iso1444334b.view.*

/**
 * Created by hxd on 2018/10/21.
 */
class ISO14443B : BasesFragment() {

    lateinit var views: View
    var logAdapter: LogAdapter = LogAdapter()

    override fun add(message: IMessage) {
        logAdapter.add(message)
        views.lv_log.setSelection(logAdapter.count - 1)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        var view = inflater!!.inflate(R.layout.view_iso1444334b, null)
        views = view
        view.lv_log.adapter = logAdapter
        views = view
        views.btn_clear_log.setOnClickListener {
            LogManager.instance().clear()
            logAdapter.notifyDataSetChanged()
        }
        bindView()
        return view
    }

    fun bindView() {
        views.bt_typeb.setOnClickListener { CommPacket.GeneralRequest("500004410000000015", SerialReadThread.ReaderListener { }) }
        views.bt_sendAPDU.setOnClickListener { CommPacket.PiccAPDU(views.et_apdu.text.toString(), SerialReadThread.ReaderListener { }) }
        views.bt_apduChannel.setOnClickListener { CommPacket.PiccTransfer(views.et_apduChannel.text.toString(), SerialReadThread.ReaderListener { }) }
    }


}